/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.vonage.client.AbstractClient;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.insight.AdvancedInsightEndpoint;
import com.vonage.client.insight.AdvancedInsightRequest;
import com.vonage.client.insight.AdvancedInsightResponse;
import com.vonage.client.insight.BasicInsightEndpoint;
import com.vonage.client.insight.BasicInsightRequest;
import com.vonage.client.insight.BasicInsightResponse;
import com.vonage.client.insight.StandardInsightEndpoint;
import com.vonage.client.insight.StandardInsightRequest;
import com.vonage.client.insight.StandardInsightResponse;

public class InsightClient
extends AbstractClient {
    protected BasicInsightEndpoint basic;
    protected StandardInsightEndpoint standard;
    protected AdvancedInsightEndpoint advanced;

    public InsightClient(HttpWrapper httpWrapper) {
        super(httpWrapper);
        this.basic = new BasicInsightEndpoint(httpWrapper);
        this.standard = new StandardInsightEndpoint(httpWrapper);
        this.advanced = new AdvancedInsightEndpoint(httpWrapper);
    }

    public BasicInsightResponse getBasicNumberInsight(String number) throws VonageResponseParseException, VonageClientException {
        return this.getBasicNumberInsight(BasicInsightRequest.withNumber(number));
    }

    public BasicInsightResponse getBasicNumberInsight(String number, String country) throws VonageResponseParseException, VonageClientException {
        return this.getBasicNumberInsight(BasicInsightRequest.withNumberAndCountry(number, country));
    }

    public BasicInsightResponse getBasicNumberInsight(BasicInsightRequest basicInsightRequest) throws VonageResponseParseException, VonageClientException {
        return (BasicInsightResponse)this.basic.execute(basicInsightRequest);
    }

    public StandardInsightResponse getStandardNumberInsight(String number) throws VonageResponseParseException, VonageClientException {
        return this.getStandardNumberInsight(StandardInsightRequest.withNumber(number));
    }

    public StandardInsightResponse getStandardNumberInsight(String number, String country) throws VonageResponseParseException, VonageClientException {
        return this.getStandardNumberInsight(StandardInsightRequest.withNumberAndCountry(number, country));
    }

    public StandardInsightResponse getStandardNumberInsight(StandardInsightRequest standardInsightRequest) throws VonageResponseParseException, VonageClientException {
        return (StandardInsightResponse)this.standard.execute(standardInsightRequest);
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(String number) throws VonageResponseParseException, VonageClientException {
        return this.getAdvancedNumberInsight(AdvancedInsightRequest.withNumber(number));
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(String number, String country) throws VonageResponseParseException, VonageClientException {
        return this.getAdvancedNumberInsight(AdvancedInsightRequest.withNumberAndCountry(number, country));
    }

    public AdvancedInsightResponse getAdvancedNumberInsight(AdvancedInsightRequest advancedInsightRequest) throws VonageResponseParseException, VonageClientException {
        return (AdvancedInsightResponse)this.advanced.execute(advancedInsightRequest);
    }
}

