/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.redact;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vonage.client.VonageUnexpectedException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RedactRequest {
    private String id;
    private Product product;
    private Type type;

    public RedactRequest(String id, Product product) {
        this.id = id;
        this.product = product;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            throw new VonageUnexpectedException("Failed to produce json from RedactRequest object.", jpe);
        }
    }

    public static enum Type {
        INBOUND,
        OUTBOUND;


        @JsonValue
        public String getValue() {
            return this.name().toLowerCase();
        }
    }

    public static enum Product {
        SMS("sms"),
        VOICE("voice"),
        NUMBER_INSIGHTS("number-insight"),
        VERIFY("verify"),
        VERIFY_SDK("verify-sdk"),
        MESSAGES("messages"),
        WORKFLOW("workflow");

        private String value;

        private Product(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

