/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.sms;

import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.sms.SearchRejectedMessagesEndpoint;
import com.vonage.client.sms.SearchRejectedMessagesRequest;
import com.vonage.client.sms.SearchRejectedMessagesResponse;
import com.vonage.client.sms.SearchSmsRequest;
import com.vonage.client.sms.SearchSmsResponse;
import com.vonage.client.sms.SendMessageEndpoint;
import com.vonage.client.sms.SmsDateSearchRequest;
import com.vonage.client.sms.SmsIdSearchRequest;
import com.vonage.client.sms.SmsSearchEndpoint;
import com.vonage.client.sms.SmsSingleSearchEndpoint;
import com.vonage.client.sms.SmsSingleSearchResponse;
import com.vonage.client.sms.SmsSubmissionResponse;
import com.vonage.client.sms.messages.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class SmsClient {
    private SendMessageEndpoint message;
    private SmsSearchEndpoint search;
    private SearchRejectedMessagesEndpoint rejected;
    private SmsSingleSearchEndpoint singleSearch;

    public SmsClient(HttpWrapper httpWrapper) {
        this.message = new SendMessageEndpoint(httpWrapper);
        this.search = new SmsSearchEndpoint(httpWrapper);
        this.rejected = new SearchRejectedMessagesEndpoint(httpWrapper);
        this.singleSearch = new SmsSingleSearchEndpoint(httpWrapper);
    }

    public SmsSubmissionResponse submitMessage(Message message) throws VonageResponseParseException, VonageClientException {
        return (SmsSubmissionResponse)this.message.execute(message);
    }

    public SearchSmsResponse searchMessages(SearchSmsRequest request) throws VonageResponseParseException, VonageClientException {
        return (SearchSmsResponse)this.search.execute(request);
    }

    public SearchSmsResponse searchMessages(String id, String ... ids) throws VonageResponseParseException, VonageClientException {
        ArrayList<String> idList = new ArrayList<String>(ids.length + 1);
        idList.add(id);
        idList.addAll(Arrays.asList(ids));
        return this.searchMessages(new SmsIdSearchRequest(idList));
    }

    public SearchSmsResponse searchMessages(Date date, String to) throws VonageResponseParseException, VonageClientException {
        return this.searchMessages(new SmsDateSearchRequest(date, to));
    }

    public SearchRejectedMessagesResponse searchRejectedMessages(SearchRejectedMessagesRequest request) throws VonageResponseParseException, VonageClientException {
        return (SearchRejectedMessagesResponse)this.rejected.execute(request);
    }

    public SearchRejectedMessagesResponse searchRejectedMessages(Date date, String to) throws VonageResponseParseException, VonageClientException {
        return this.searchRejectedMessages(new SearchRejectedMessagesRequest(date, to));
    }

    public SmsSingleSearchResponse getSms(String id) throws VonageResponseParseException, VonageClientException {
        return (SmsSingleSearchResponse)this.singleSearch.execute(id);
    }
}

