/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.sms.callback;

import com.vonage.client.auth.RequestSigning;
import com.vonage.client.auth.hashutils.HashUtil;
import com.vonage.client.sms.HexUtil;
import com.vonage.client.sms.callback.VonageCallbackRequestValidationException;
import com.vonage.client.sms.callback.messages.MO;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractMOServlet
extends HttpServlet {
    private static final long serialVersionUID = 8745764381059238419L;
    private static final int MAX_CONSUMER_THREADS = 10;
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP_DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private final boolean validateSignature;
    private final String signatureSharedSecret;
    private final boolean validateUsernamePassword;
    private final String expectedUsername;
    private final String expectedPassword;
    private final HashUtil.HashType hashType;
    protected Executor consumer;

    public AbstractMOServlet(boolean validateSignature, String signatureSharedSecret, boolean validateUsernamePassword, String expectedUsername, String expectedPassword) {
        this.hashType = HashUtil.HashType.MD5;
        this.consumer = Executors.newFixedThreadPool(10);
        this.validateSignature = validateSignature;
        this.signatureSharedSecret = signatureSharedSecret;
        this.validateUsernamePassword = validateUsernamePassword;
        this.expectedUsername = expectedUsername;
        this.expectedPassword = expectedPassword;
    }

    public AbstractMOServlet(boolean validateSignature, String signatureSharedSecret, boolean validateUsernamePassword, String expectedUsername, String expectedPassword, HashUtil.HashType hashType) {
        this.validateSignature = validateSignature;
        this.signatureSharedSecret = signatureSharedSecret;
        this.validateUsernamePassword = validateUsernamePassword;
        this.expectedUsername = expectedUsername;
        this.expectedPassword = expectedPassword;
        this.hashType = hashType;
        this.consumer = Executors.newFixedThreadPool(10);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    private void validateRequest(HttpServletRequest request) throws VonageCallbackRequestValidationException {
        boolean passed = true;
        if (this.validateUsernamePassword) {
            String username = request.getParameter("username");
            String password = request.getParameter("password");
            if (this.expectedUsername != null && !this.expectedUsername.equals(username)) {
                passed = false;
            }
            if (this.expectedPassword != null && !this.expectedPassword.equals(password)) {
                passed = false;
            }
        }
        if (!passed) {
            throw new VonageCallbackRequestValidationException("Bad Credentials");
        }
        if (this.validateSignature && !RequestSigning.verifyRequestSignature(request, this.signatureSharedSecret, this.hashType)) {
            throw new VonageCallbackRequestValidationException("Bad Signature");
        }
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain");
        try {
            this.validateRequest(request);
            String messageId = request.getParameter("messageId");
            String sender = request.getParameter("msisdn");
            String destination = request.getParameter("to");
            if (sender == null || destination == null || messageId == null) {
                throw new VonageCallbackRequestValidationException("Missing mandatory fields");
            }
            MO.MESSAGE_TYPE messageType = AbstractMOServlet.parseMessageType(request.getParameter("type"));
            BigDecimal price = AbstractMOServlet.parsePrice(request.getParameter("price"));
            Date timeStamp = AbstractMOServlet.parseTimeStamp(request.getParameter("message-timestamp"));
            MO mo = new MO(messageId, messageType, sender, destination, price, timeStamp);
            if (messageType == MO.MESSAGE_TYPE.TEXT || messageType == MO.MESSAGE_TYPE.UNICODE) {
                String messageBody = request.getParameter("text");
                if (messageBody == null) {
                    throw new VonageCallbackRequestValidationException("Missing text field");
                }
                mo.setTextData(messageBody, request.getParameter("keyword"));
            } else if (messageType == MO.MESSAGE_TYPE.BINARY) {
                byte[] data = AbstractMOServlet.parseBinaryData(request.getParameter("data"));
                if (data == null) {
                    throw new VonageCallbackRequestValidationException("Missing data field");
                }
                mo.setBinaryData(data, AbstractMOServlet.parseBinaryData(request.getParameter("udh")));
            }
            AbstractMOServlet.extractConcatenationData(request, mo);
            mo.setNetworkCode(request.getParameter("network-code"));
            mo.setSessionId(request.getParameter("sessionId"));
            ConsumeTask task = new ConsumeTask(this, mo);
            this.consumer.execute(task);
            try (PrintWriter out = response.getWriter();){
                out.print("OK");
                out.flush();
            }
        }
        catch (VonageCallbackRequestValidationException exc) {
            response.sendError(400, exc.getMessage());
        }
    }

    private static void extractConcatenationData(HttpServletRequest request, MO mo) throws VonageCallbackRequestValidationException {
        String concatString = request.getParameter("concat");
        if (concatString != null && concatString.equals("true")) {
            int partNumber;
            int totalParts;
            String reference = request.getParameter("concat-ref");
            try {
                totalParts = Integer.parseInt(request.getParameter("concat-total"));
                partNumber = Integer.parseInt(request.getParameter("concat-part"));
            }
            catch (Exception e) {
                throw new VonageCallbackRequestValidationException("bad concat fields");
            }
            mo.setConcatenationData(reference, totalParts, partNumber);
        }
    }

    private static MO.MESSAGE_TYPE parseMessageType(String str) throws VonageCallbackRequestValidationException {
        if (str != null) {
            for (MO.MESSAGE_TYPE type : MO.MESSAGE_TYPE.values()) {
                if (!type.getType().equals(str)) continue;
                return type;
            }
        }
        throw new VonageCallbackRequestValidationException("Unrecognized message type: " + str);
    }

    private static Date parseTimeStamp(String str) throws VonageCallbackRequestValidationException {
        if (str != null) {
            try {
                return TIMESTAMP_DATE_FORMAT.get().parse(str);
            }
            catch (ParseException e) {
                throw new VonageCallbackRequestValidationException("Bad message-timestamp format", e);
            }
        }
        return null;
    }

    private static BigDecimal parsePrice(String str) throws VonageCallbackRequestValidationException {
        if (str != null) {
            try {
                return new BigDecimal(str);
            }
            catch (Exception e) {
                throw new VonageCallbackRequestValidationException("Bad price field", e);
            }
        }
        return null;
    }

    private static byte[] parseBinaryData(String str) {
        if (str != null) {
            return HexUtil.hexToBytes(str);
        }
        return null;
    }

    public abstract void consume(MO var1);

    private static final class ConsumeTask
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = -5270583545977374866L;
        private final AbstractMOServlet parent;
        private final MO mo;

        public ConsumeTask(AbstractMOServlet parent, MO mo) {
            this.parent = parent;
            this.mo = mo;
        }

        @Override
        public void run() {
            this.parent.consume(this.mo);
        }
    }
}

