/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vonage.client.verify.SearchVerifyResponse;
import com.vonage.client.verify.VerifyDetails;
import com.vonage.client.verify.VerifyStatus;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;

public class SearchVerifyResponseDeserializer
extends JsonDeserializer<SearchVerifyResponse> {
    public SearchVerifyResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.has("verification_requests")) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            return (SearchVerifyResponse)mapper.readValue(node.toString(), SearchVerifyResponse.class);
        }
        if (node.has("error_text")) {
            return new SearchVerifyResponse(VerifyStatus.fromInt(node.get("status").asInt()), node.get("error_text").asText());
        }
        VerifyDetails details = (VerifyDetails)p.getCodec().treeToValue((TreeNode)node, VerifyDetails.class);
        return new SearchVerifyResponse(Collections.singletonList(details));
    }
}

