/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.vonage.client.AbstractClient;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.verify.CheckEndpoint;
import com.vonage.client.verify.CheckResponse;
import com.vonage.client.verify.ControlEndpoint;
import com.vonage.client.verify.ControlRequest;
import com.vonage.client.verify.ControlResponse;
import com.vonage.client.verify.Psd2Endpoint;
import com.vonage.client.verify.Psd2Request;
import com.vonage.client.verify.SearchEndpoint;
import com.vonage.client.verify.SearchVerifyResponse;
import com.vonage.client.verify.VerifyControlCommand;
import com.vonage.client.verify.VerifyEndpoint;
import com.vonage.client.verify.VerifyRequest;
import com.vonage.client.verify.VerifyResponse;
import java.util.Locale;

public class VerifyClient
extends AbstractClient {
    private CheckEndpoint check;
    private VerifyEndpoint verify;
    private SearchEndpoint search;
    private ControlEndpoint control;
    private Psd2Endpoint psd2;

    public VerifyClient(HttpWrapper httpWrapper) {
        super(httpWrapper);
        this.check = new CheckEndpoint(httpWrapper);
        this.search = new SearchEndpoint(httpWrapper);
        this.verify = new VerifyEndpoint(httpWrapper);
        this.control = new ControlEndpoint(httpWrapper);
        this.psd2 = new Psd2Endpoint(httpWrapper);
    }

    public VerifyResponse verify(String number, String brand) throws VonageResponseParseException, VonageClientException {
        return this.verify.verify(number, brand);
    }

    public VerifyResponse verify(String number, String brand, VerifyRequest.Workflow workflow) throws VonageResponseParseException, VonageClientException {
        return this.verify.verify(number, brand, workflow);
    }

    public VerifyResponse verify(String number, String brand, String from) throws VonageClientException, VonageResponseParseException {
        return this.verify.verify(number, brand, from);
    }

    public VerifyResponse verify(String number, String brand, String from, int length, Locale locale) throws VonageClientException, VonageResponseParseException {
        return this.verify.verify(number, brand, from, length, locale);
    }

    public VerifyResponse verify(String number, String brand, String from, int length, Locale locale, VerifyRequest.LineType type) throws VonageClientException {
        return this.verify.verify(number, brand, from, length, locale, type);
    }

    public VerifyResponse verify(VerifyRequest request) throws VonageClientException, VonageResponseParseException {
        return this.verify.verify(request);
    }

    public CheckResponse check(String requestId, String code) throws VonageClientException, VonageResponseParseException {
        return this.check.check(requestId, code);
    }

    public CheckResponse check(String requestId, String code, String ipAddress) throws VonageClientException, VonageResponseParseException {
        return this.check.check(requestId, code, ipAddress);
    }

    public SearchVerifyResponse search(String requestId) throws VonageClientException, VonageResponseParseException {
        return this.search.search(requestId);
    }

    public SearchVerifyResponse search(String ... requestIds) throws VonageClientException, VonageResponseParseException {
        return this.search.search(requestIds);
    }

    public ControlResponse advanceVerification(String requestId) throws VonageClientException, VonageResponseParseException {
        return (ControlResponse)this.control.execute(new ControlRequest(requestId, VerifyControlCommand.TRIGGER_NEXT_EVENT));
    }

    public ControlResponse cancelVerification(String requestId) throws VonageClientException, VonageResponseParseException {
        return (ControlResponse)this.control.execute(new ControlRequest(requestId, VerifyControlCommand.CANCEL));
    }

    public VerifyResponse psd2Verify(String number, Double amount, String payee) throws VonageClientException, VonageResponseParseException {
        return this.psd2.psd2Verify(number, amount, payee);
    }

    public VerifyResponse psd2Verify(String number, Double amount, String payee, Psd2Request.Workflow workflow) throws VonageClientException, VonageResponseParseException {
        return this.psd2.psd2Verify(number, amount, payee, workflow);
    }

    public VerifyResponse psd2Verify(Psd2Request psd2Request) throws VonageClientException, VonageResponseParseException {
        return this.psd2.psd2Verify(psd2Request);
    }
}

