/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MachineDetection {
    CONTINUE,
    HANGUP,
    UNKNOWN;

    private static final Map<String, MachineDetection> MACHINE_DETECTION_INDEX;

    @JsonValue
    public String toString() {
        return this.name().toLowerCase();
    }

    @JsonCreator
    public static MachineDetection fromString(String name) {
        MachineDetection foundMachineDetection = MACHINE_DETECTION_INDEX.get(name.toUpperCase());
        return foundMachineDetection != null ? foundMachineDetection : UNKNOWN;
    }

    static {
        MACHINE_DETECTION_INDEX = new HashMap<String, MachineDetection>();
        for (MachineDetection machineDetection : MachineDetection.values()) {
            MACHINE_DETECTION_INDEX.put(machineDetection.name(), machineDetection);
        }
    }
}

