/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.vonage.client.AbstractClient;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.voice.Call;
import com.vonage.client.voice.CallEvent;
import com.vonage.client.voice.CallInfo;
import com.vonage.client.voice.CallInfoPage;
import com.vonage.client.voice.CallModifier;
import com.vonage.client.voice.CallsEndpoint;
import com.vonage.client.voice.CallsFilter;
import com.vonage.client.voice.DownloadRecordingEndpoint;
import com.vonage.client.voice.DtmfEndpoint;
import com.vonage.client.voice.DtmfResponse;
import com.vonage.client.voice.ModifyCallAction;
import com.vonage.client.voice.ModifyCallResponse;
import com.vonage.client.voice.Recording;
import com.vonage.client.voice.StreamRequest;
import com.vonage.client.voice.StreamResponse;
import com.vonage.client.voice.StreamsEndpoint;
import com.vonage.client.voice.TalkEndpoint;
import com.vonage.client.voice.TalkRequest;
import com.vonage.client.voice.TalkResponse;
import com.vonage.client.voice.TextToSpeechLanguage;
import com.vonage.client.voice.VoiceName;
import com.vonage.client.voice.ncco.Ncco;

public class VoiceClient
extends AbstractClient {
    protected final CallsEndpoint calls;
    protected final StreamsEndpoint streams;
    protected final TalkEndpoint talk;
    protected final DtmfEndpoint dtmf;
    protected final DownloadRecordingEndpoint downloadRecording;

    public VoiceClient(HttpWrapper httpWrapper) {
        super(httpWrapper);
        this.calls = new CallsEndpoint(httpWrapper);
        this.streams = new StreamsEndpoint(httpWrapper);
        this.talk = new TalkEndpoint(httpWrapper);
        this.dtmf = new DtmfEndpoint(httpWrapper);
        this.downloadRecording = new DownloadRecordingEndpoint(httpWrapper);
    }

    public CallEvent createCall(Call callRequest) throws VonageResponseParseException, VonageClientException {
        return this.calls.post(callRequest);
    }

    public CallInfoPage listCalls() throws VonageResponseParseException, VonageClientException {
        return this.listCalls(null);
    }

    public CallInfoPage listCalls(CallsFilter filter) throws VonageResponseParseException, VonageClientException {
        return this.calls.get(filter);
    }

    public CallInfo getCallDetails(String uuid) throws VonageResponseParseException, VonageClientException {
        return this.calls.get(uuid);
    }

    public DtmfResponse sendDtmf(String uuid, String digits) throws VonageResponseParseException, VonageClientException {
        return this.dtmf.put(uuid, digits);
    }

    public ModifyCallResponse modifyCall(String uuid, ModifyCallAction action) throws VonageResponseParseException, VonageClientException {
        return this.modifyCall(new CallModifier(uuid, action));
    }

    public ModifyCallResponse modifyCall(CallModifier modifier) throws VonageResponseParseException, VonageClientException {
        return this.calls.put(modifier);
    }

    public ModifyCallResponse transferCall(String uuid, String nccoUrl) throws VonageResponseParseException, VonageClientException {
        return this.modifyCall(CallModifier.transferCall(uuid, nccoUrl));
    }

    public ModifyCallResponse transferCall(String uuid, Ncco ncco) throws VonageResponseParseException, VonageClientException {
        return this.modifyCall(CallModifier.transferCall(uuid, ncco));
    }

    public StreamResponse startStream(String uuid, String streamUrl, int loop) throws VonageResponseParseException, VonageClientException {
        return this.streams.put(new StreamRequest(uuid, streamUrl, loop));
    }

    public StreamResponse startStream(String uuid, String streamUrl) throws VonageResponseParseException, VonageClientException {
        return this.streams.put(new StreamRequest(uuid, streamUrl, 1));
    }

    public StreamResponse stopStream(String uuid) throws VonageResponseParseException, VonageClientException {
        return this.streams.delete(uuid);
    }

    public TalkResponse startTalk(String uuid, String text) throws VonageResponseParseException, VonageClientException {
        return this.talk.put(new TalkRequest(uuid, text));
    }

    @Deprecated
    public TalkResponse startTalk(String uuid, String text, VoiceName voiceName) throws VonageResponseParseException, VonageClientException {
        return this.talk.put(new TalkRequest(uuid, text, voiceName));
    }

    public TalkResponse startTalk(String uuid, String text, TextToSpeechLanguage language, Integer style) throws VonageResponseParseException, VonageClientException {
        return this.talk.put(new TalkRequest(uuid, text, language, (int)style));
    }

    public TalkResponse startTalk(String uuid, String text, TextToSpeechLanguage language) throws VonageResponseParseException, VonageClientException {
        return this.talk.put(new TalkRequest(uuid, text, language));
    }

    public TalkResponse startTalk(String uuid, String text, int loop) throws VonageResponseParseException, VonageClientException {
        return this.talk.put(new TalkRequest(uuid, text, loop));
    }

    @Deprecated
    public TalkResponse startTalk(String uuid, String text, VoiceName voiceName, int loop) throws VonageResponseParseException, VonageClientException {
        return this.talk.put(new TalkRequest(uuid, text, voiceName, loop));
    }

    public TalkResponse startTalk(String uuid, String text, TextToSpeechLanguage language, int style, int loop) throws VonageResponseParseException, VonageClientException {
        return this.talk.put(new TalkRequest(uuid, text, language, style, loop));
    }

    public TalkResponse startTalk(String uuid, String text, TextToSpeechLanguage language, int style) throws VonageResponseParseException, VonageClientException {
        return this.talk.put(new TalkRequest(uuid, text, language, style));
    }

    public TalkResponse stopTalk(String uuid) throws VonageResponseParseException, VonageClientException {
        return this.talk.delete(uuid);
    }

    public Recording downloadRecording(String recordingUrl) throws VonageResponseParseException, VonageClientException {
        return (Recording)this.downloadRecording.execute(recordingUrl);
    }
}

