/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.DtmfSettings;
import com.vonage.client.voice.ncco.EventMethod;
import com.vonage.client.voice.ncco.SpeechSettings;
import java.util.Arrays;
import java.util.Collection;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InputAction
implements Action {
    private static final String ACTION = "input";
    @JsonProperty(required=true)
    private Collection<String> type;
    private DtmfSettings dtmf;
    private Collection<String> eventUrl;
    private SpeechSettings speech;
    private EventMethod eventMethod;

    private InputAction(Builder builder) {
        this.type = builder.type;
        this.dtmf = builder.dtmf;
        this.eventUrl = builder.eventUrl;
        this.eventMethod = builder.eventMethod;
        this.speech = builder.speech;
    }

    @Override
    public String getAction() {
        return ACTION;
    }

    public Collection<String> getType() {
        return this.type;
    }

    public DtmfSettings getDtmf() {
        return this.dtmf;
    }

    public Collection<String> getEventUrl() {
        return this.eventUrl;
    }

    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    public SpeechSettings getSpeech() {
        return this.speech;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DtmfSettings dtmf;
        private Collection<String> eventUrl;
        private EventMethod eventMethod;
        private SpeechSettings speech;
        private Collection<String> type;

        public Builder dtmf(DtmfSettings dtmf) {
            this.dtmf = dtmf;
            return this;
        }

        public Builder eventUrl(Collection<String> eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventUrl(String ... eventUrl) {
            return this.eventUrl(Arrays.asList(eventUrl));
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public Builder speech(SpeechSettings speech) {
            this.speech = speech;
            return this;
        }

        public Builder type(Collection<String> type) {
            this.type = type;
            return this;
        }

        public InputAction build() {
            return new InputAction(this);
        }
    }
}

