/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.vonage.client.voice.ncco.Action;
import java.util.Arrays;
import java.util.Collection;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamAction
implements Action {
    private static final String ACTION = "stream";
    private Collection<String> streamUrl;
    private Float level;
    private Boolean bargeIn;
    private Integer loop;

    private StreamAction(Builder builder) {
        this.streamUrl = builder.streamUrl;
        this.level = builder.level;
        this.bargeIn = builder.bargeIn;
        this.loop = builder.loop;
    }

    @Override
    public String getAction() {
        return ACTION;
    }

    public Collection<String> getStreamUrl() {
        return this.streamUrl;
    }

    public Float getLevel() {
        return this.level;
    }

    public Boolean getBargeIn() {
        return this.bargeIn;
    }

    public Integer getLoop() {
        return this.loop;
    }

    public static Builder builder(Collection<String> streamUrl) {
        return new Builder(streamUrl);
    }

    public static Builder builder(String ... streamUrl) {
        return new Builder(streamUrl);
    }

    public static class Builder {
        private Collection<String> streamUrl;
        private Float level;
        private Boolean bargeIn;
        private Integer loop;

        public Builder(Collection<String> streamUrl) {
            this.streamUrl = streamUrl;
        }

        public Builder(String ... streamUrl) {
            this(Arrays.asList(streamUrl));
        }

        public Builder streamUrl(Collection<String> streamUrl) {
            this.streamUrl = streamUrl;
            return this;
        }

        public Builder streamUrl(String ... streamUrl) {
            return this.streamUrl(Arrays.asList(streamUrl));
        }

        public Builder level(Float level) {
            this.level = level;
            return this;
        }

        public Builder bargeIn(Boolean bargeIn) {
            this.bargeIn = bargeIn;
            return this;
        }

        public Builder loop(Integer loop) {
            this.loop = loop;
            return this;
        }

        public StreamAction build() {
            return new StreamAction(this);
        }
    }
}

