/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.vonage.client.voice.TextToSpeechLanguage;
import com.vonage.client.voice.VoiceName;
import com.vonage.client.voice.ncco.Action;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TalkAction
implements Action {
    private static final String ACTION = "talk";
    private String text;
    private Boolean bargeIn;
    private Integer loop;
    private Float level;
    private TextToSpeechLanguage language;
    private Integer style;
    @Deprecated
    private VoiceName voiceName;

    private TalkAction(Builder builder) {
        this.text = builder.text;
        this.bargeIn = builder.bargeIn;
        this.loop = builder.loop;
        this.level = builder.level;
        this.voiceName = builder.voiceName;
        this.style = builder.style;
        this.language = builder.language;
    }

    @Override
    public String getAction() {
        return ACTION;
    }

    public String getText() {
        return this.text;
    }

    public Boolean getBargeIn() {
        return this.bargeIn;
    }

    public Integer getLoop() {
        return this.loop;
    }

    public Float getLevel() {
        return this.level;
    }

    public TextToSpeechLanguage getLanguage() {
        return this.language;
    }

    public Integer getStyle() {
        return this.style;
    }

    @Deprecated
    public VoiceName getVoiceName() {
        return this.voiceName;
    }

    public static Builder builder(String text) {
        return new Builder(text);
    }

    public static class Builder {
        private String text;
        private Boolean bargeIn = null;
        private Integer loop = null;
        private Float level = null;
        private VoiceName voiceName = null;
        private TextToSpeechLanguage language = null;
        private Integer style = null;

        public Builder(String text) {
            this.text = text;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder bargeIn(Boolean bargeIn) {
            this.bargeIn = bargeIn;
            return this;
        }

        public Builder loop(Integer loop) {
            this.loop = loop;
            return this;
        }

        public Builder level(Float level) {
            this.level = level;
            return this;
        }

        public Builder language(TextToSpeechLanguage language) {
            this.language = language;
            return this;
        }

        public Builder style(Integer style) {
            this.style = style;
            return this;
        }

        @Deprecated
        public Builder voiceName(VoiceName voiceName) {
            this.voiceName = voiceName;
            return this;
        }

        public TalkAction build() {
            return new TalkAction(this);
        }
    }
}

