/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.account;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.account.PricingRequest;
import com.vonage.client.account.PricingResponse;
import com.vonage.client.auth.TokenAuthMethod;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;

class PricingEndpoint
extends AbstractMethod<PricingRequest, PricingResponse> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/account/get-pricing/outbound/%s";

    PricingEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(PricingRequest request) {
        String uri = this.httpWrapper.getHttpConfig().getRestBaseUri() + String.format(PATH, request.getServiceType());
        return RequestBuilder.get((String)uri).setHeader("Accept", "application/json").addParameter("country", request.getCountryCode());
    }

    @Override
    public PricingResponse parseResponse(HttpResponse response) throws IOException {
        return PricingResponse.fromJson(basicResponseHandler.handleResponse(response));
    }
}

