/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.account;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageBadRequestException;
import com.vonage.client.VonageClientException;
import com.vonage.client.account.SecretRequest;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;

class RevokeSecretEndpoint
extends AbstractMethod<SecretRequest, Void> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/accounts/%s/secrets/%s";

    RevokeSecretEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(SecretRequest secretRequest) throws UnsupportedEncodingException {
        if (secretRequest.getApiKey() == null) {
            throw new IllegalArgumentException("API key is required.");
        }
        if (secretRequest.getSecretId() == null) {
            throw new IllegalArgumentException("Secret id is required.");
        }
        String uri = String.format(this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH, secretRequest.getApiKey(), secretRequest.getSecretId());
        return RequestBuilder.delete((String)uri);
    }

    @Override
    public Void parseResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 204) {
            throw new VonageBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return null;
    }

    @Override
    protected RequestBuilder applyAuth(RequestBuilder request) throws VonageClientException {
        return this.getAuthMethod(this.getAcceptableAuthMethods()).applyAsBasicAuth(request);
    }
}

