/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application;

import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.application.Application;
import com.vonage.client.application.ApplicationList;
import com.vonage.client.application.CreateApplicationEndpoint;
import com.vonage.client.application.DeleteApplicationEndpoint;
import com.vonage.client.application.GetApplicationEndpoint;
import com.vonage.client.application.ListApplicationRequest;
import com.vonage.client.application.ListApplicationsEndpoint;
import com.vonage.client.application.UpdateApplicationEndpoint;

public class ApplicationClient {
    final CreateApplicationEndpoint createApplicationEndpoint;
    final UpdateApplicationEndpoint updateApplicationEndpoint;
    final GetApplicationEndpoint getApplicationEndpoint;
    final DeleteApplicationEndpoint deleteApplicationEndpoint;
    final ListApplicationsEndpoint listApplicationsEndpoint;

    public ApplicationClient(HttpWrapper httpWrapper) {
        this.createApplicationEndpoint = new CreateApplicationEndpoint(httpWrapper);
        this.updateApplicationEndpoint = new UpdateApplicationEndpoint(httpWrapper);
        this.getApplicationEndpoint = new GetApplicationEndpoint(httpWrapper);
        this.deleteApplicationEndpoint = new DeleteApplicationEndpoint(httpWrapper);
        this.listApplicationsEndpoint = new ListApplicationsEndpoint(httpWrapper);
    }

    public Application createApplication(Application application) throws VonageResponseParseException, VonageClientException {
        return (Application)this.createApplicationEndpoint.execute(application);
    }

    public Application updateApplication(Application application) throws VonageResponseParseException, VonageClientException {
        return (Application)this.updateApplicationEndpoint.execute(application);
    }

    public Application getApplication(String id) throws VonageResponseParseException, VonageClientException {
        return (Application)this.getApplicationEndpoint.execute(id);
    }

    public void deleteApplication(String id) throws VonageResponseParseException, VonageClientException {
        this.deleteApplicationEndpoint.execute(id);
    }

    public ApplicationList listApplications() throws VonageResponseParseException, VonageClientException {
        return this.listApplications(null);
    }

    public ApplicationList listApplications(ListApplicationRequest listApplicationRequest) throws VonageResponseParseException, VonageClientException {
        return (ApplicationList)this.listApplicationsEndpoint.execute(listApplicationRequest);
    }
}

