/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application;

import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageBadRequestException;
import com.vonage.client.VonageClientException;
import com.vonage.client.application.ApplicationList;
import com.vonage.client.application.ApplicationMethod;
import com.vonage.client.application.ListApplicationRequest;
import com.vonage.client.auth.TokenAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;

class ListApplicationsEndpoint
extends ApplicationMethod<ListApplicationRequest, ApplicationList> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/applications";

    ListApplicationsEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(ListApplicationRequest request) throws UnsupportedEncodingException {
        RequestBuilder builder = RequestBuilder.get((String)(this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v2") + PATH)).setHeader("Accept", "application/json");
        if (request != null) {
            if (request.getPageSize() > 0L) {
                builder.addParameter("page_size", String.valueOf(request.getPageSize()));
            }
            if (request.getPage() > 0L) {
                builder.addParameter("page", String.valueOf(request.getPage()));
            }
        }
        return builder;
    }

    @Override
    public ApplicationList parseResponse(HttpResponse response) throws IOException, VonageClientException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new VonageBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return ApplicationList.fromJson(basicResponseHandler.handleResponse(response));
    }
}

