/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.vonage.client.insight.BaseInsightRequest;

public class AdvancedInsightRequest
extends BaseInsightRequest {
    private final boolean async;
    private final String callback;
    private final String ipAddress;
    private final Boolean realTimeData;

    private AdvancedInsightRequest(Builder builder) {
        super(builder.number, builder.country);
        this.cnam = builder.cnam;
        this.ipAddress = builder.ipAddress;
        this.callback = builder.callback;
        this.async = builder.async;
        if (!this.async) {
            this.realTimeData = builder.realTimeData;
        } else {
            this.realTimeData = null;
            if (this.callback == null || this.callback.isEmpty()) {
                throw new IllegalStateException("You must define a callback URL when using asynchronous insights.");
            }
        }
    }

    public static Builder builder(String number) {
        return new Builder(number);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Boolean getRealTimeData() {
        return this.realTimeData;
    }

    public Boolean getCnam() {
        return this.cnam;
    }

    @Deprecated
    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String getCallback() {
        return this.callback;
    }

    public static AdvancedInsightRequest withNumber(String number) {
        return new Builder(number).build();
    }

    public static AdvancedInsightRequest withNumberAndCountry(String number, String country) {
        return new Builder(number).country(country).build();
    }

    public static class Builder {
        protected boolean async;
        protected Boolean cnam;
        protected Boolean realTimeData;
        protected String number;
        protected String country;
        protected String ipAddress;
        protected String callback;

        protected Builder(String number) {
            this.number = number;
        }

        protected Builder() {
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder cnam(boolean cnam) {
            this.cnam = cnam;
            return this;
        }

        @Deprecated
        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder async(boolean async) {
            this.async = async;
            return this;
        }

        public Builder callback(String url) {
            this.callback = url;
            return this;
        }

        public Builder realTimeData(boolean realTimeData) {
            this.realTimeData = realTimeData;
            return this;
        }

        public AdvancedInsightRequest build() {
            return new AdvancedInsightRequest(this);
        }
    }
}

