/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.insight.BasicInsightRequest;
import com.vonage.client.insight.BasicInsightResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;

class BasicInsightEndpoint
extends AbstractMethod<BasicInsightRequest, BasicInsightResponse> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/ni/basic/json";

    BasicInsightEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(BasicInsightRequest request) throws UnsupportedEncodingException {
        String uri = this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH;
        RequestBuilder requestBuilder = RequestBuilder.post((String)uri).setHeader("Accept", "application/json").addParameter("number", request.getNumber());
        if (request.getCountry() != null) {
            requestBuilder.addParameter("country", request.getCountry());
        }
        return requestBuilder;
    }

    @Override
    public BasicInsightResponse parseResponse(HttpResponse response) throws IOException {
        return BasicInsightResponse.fromJson(basicResponseHandler.handleResponse(response));
    }
}

