/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;

public enum InsightStatus {
    SUCCESS(0),
    THROTTLED(1),
    INVALID_PARAMS(3),
    INVALID_CREDENTIALS(4),
    INTERNAL_ERROR(5),
    PARTNER_QUOTA_EXCEEDED(9),
    FACILITY_NOT_ALLOWED(19),
    LOOKUP_NOT_RETURNED(43),
    REQUEST_UNPARSEABLE(999),
    UNKNOWN(Integer.MAX_VALUE);

    private int statusCode;

    private InsightStatus(int statusCode) {
        this.statusCode = statusCode;
    }

    @JsonCreator
    public static InsightStatus fromInt(int insightStatus) {
        if (insightStatus >= 43 && insightStatus <= 45) {
            InsightStatus lnr = LOOKUP_NOT_RETURNED;
            lnr.statusCode = insightStatus;
            return lnr;
        }
        return Arrays.stream(InsightStatus.values()).filter(status -> status.statusCode == insightStatus).findAny().orElseGet(() -> {
            InsightStatus wildcard = UNKNOWN;
            wildcard.statusCode = insightStatus;
            return wildcard;
        });
    }

    public int getInsightStatus() {
        return this.statusCode;
    }
}

