/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.messages.MessageType;
import java.util.EnumSet;
import java.util.Set;

public enum Channel {
    SMS(MessageType.TEXT, new MessageType[0]),
    MMS(MessageType.IMAGE, MessageType.VCARD, MessageType.AUDIO, MessageType.VIDEO),
    WHATSAPP(MessageType.TEXT, MessageType.IMAGE, MessageType.AUDIO, MessageType.VIDEO, MessageType.FILE, MessageType.TEMPLATE, MessageType.CUSTOM),
    MESSENGER(MessageType.TEXT, MessageType.IMAGE, MessageType.AUDIO, MessageType.VIDEO, MessageType.FILE),
    VIBER(MessageType.TEXT, MessageType.IMAGE);

    private final Set<MessageType> supportedTypes;

    private Channel(MessageType type1, MessageType ... additionalTypes) {
        this.supportedTypes = EnumSet.of(type1, additionalTypes);
    }

    public Set<MessageType> getSupportedMessageTypes() {
        return this.supportedTypes;
    }

    @JsonCreator
    public static Channel fromString(String value) {
        if (value == null) {
            return null;
        }
        return Channel.valueOf(value.toUpperCase());
    }

    @JsonValue
    public String toString() {
        if (this == VIBER) {
            return "viber_service";
        }
        return this.name().toLowerCase();
    }
}

