/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.internal.E164;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class MessageRequest {
    final MessageType messageType;
    final Channel channel;
    final String clientRef;
    protected String from;
    protected String to;

    protected MessageRequest(Builder<?, ?> builder, Channel channel, MessageType messageType) {
        this.messageType = Objects.requireNonNull(messageType, "Message type cannot be null");
        this.channel = Objects.requireNonNull(channel, "Channel cannot be null");
        if (!this.channel.getSupportedMessageTypes().contains((Object)this.messageType)) {
            throw new IllegalArgumentException((Object)((Object)this.messageType) + " cannot be sent via " + (Object)((Object)this.channel));
        }
        this.clientRef = this.validateClientReference(builder.clientRef);
        this.from = builder.from;
        this.to = builder.to;
        this.validateSenderAndRecipient(this.from, this.to);
    }

    protected String validateClientReference(String clientRef) {
        if (clientRef != null && clientRef.length() > 40) {
            throw new IllegalArgumentException("Client reference cannot be longer than 40 characters");
        }
        return clientRef;
    }

    protected void validateSenderAndRecipient(String from, String to) throws IllegalArgumentException {
        if (from == null || from.isEmpty()) {
            throw new IllegalArgumentException("Sender cannot be empty");
        }
        this.to = new E164(to).toString();
    }

    @JsonProperty(value="message_type")
    public MessageType getMessageType() {
        return this.messageType;
    }

    @JsonProperty(value="channel")
    public Channel getChannel() {
        return this.channel;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonProperty(value="client_ref")
    public String getClientRef() {
        return this.clientRef;
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            throw new VonageUnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName() + " object.", jpe);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.toJson();
    }

    public static abstract class Builder<M extends MessageRequest, B extends Builder<? extends M, ? extends B>> {
        protected String from;
        protected String to;
        protected String clientRef;

        protected Builder() {
        }

        public B from(String from) {
            this.from = from;
            return (B)this;
        }

        public B to(String to) {
            this.to = to;
            return (B)this;
        }

        public B clientRef(String clientRef) {
            this.clientRef = clientRef;
            return (B)this;
        }

        public abstract M build();
    }
}

