/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageUnexpectedException;
import java.io.IOException;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class MessageResponseException
extends VonageClientException {
    String type;
    String title;
    String detail;
    String instance;
    int statusCode;

    MessageResponseException() {
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="detail")
    public String getDetail() {
        return this.detail;
    }

    @JsonProperty(value="instance")
    public String getInstance() {
        return this.instance;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageResponseException response = (MessageResponseException)o;
        return this.statusCode == response.statusCode && Objects.equals(this.type, response.type) && Objects.equals(this.title, response.title) && Objects.equals(this.detail, response.detail) && Objects.equals(this.instance, response.instance);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.title, this.detail, this.instance, this.statusCode);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " {type='" + this.type + '\'' + ", title='" + this.title + '\'' + ", detail='" + this.detail + '\'' + ", instance='" + this.instance + '\'' + ", statusCode=" + this.statusCode + '}';
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreInheritedIntrospector());
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new VonageUnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName(), e);
        }
    }

    public static MessageResponseException fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (MessageResponseException)mapper.readValue(json, MessageResponseException.class);
        }
        catch (IOException e) {
            throw new VonageUnexpectedException("Failed to produce MessageResponseException from json.", e);
        }
    }

    private static class IgnoreInheritedIntrospector
    extends JacksonAnnotationIntrospector {
        private IgnoreInheritedIntrospector() {
        }

        public boolean hasIgnoreMarker(AnnotatedMember m) {
            return m.getDeclaringClass() != MessageResponseException.class || super.hasIgnoreMarker(m);
        }
    }
}

