/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessagePayload {
    protected URI url;
    protected String caption;

    public MessagePayload(String url) {
        this.url = URI.create(url);
    }

    public MessagePayload(String url, String caption) {
        this(url);
        this.caption = caption;
        if (this.caption != null && caption.isEmpty()) {
            throw new IllegalArgumentException("Caption cannot be blank");
        }
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url.toString();
    }

    @JsonProperty(value="caption")
    public String getCaption() {
        return this.caption;
    }

    public void validateUrlExtension(String ... allowed) {
        String path = this.url.getPath();
        int lastDot = path.lastIndexOf(46);
        if (lastDot < 1) {
            return;
        }
        String ext = path.substring(lastDot + 1);
        List<String> extensions = Arrays.asList(allowed);
        if (!extensions.contains(ext)) {
            throw new IllegalArgumentException("Invalid extension: '" + ext + "'. Should be one of " + extensions);
        }
    }

    public void validateCaptionLength(int max) {
        if (this.caption == null) {
            return;
        }
        if (this.caption.length() > max) {
            throw new IllegalArgumentException("Caption must be less than " + max + " characters");
        }
    }

    public void validateUrlLength(int min, int max) {
        if (this.url == null) {
            return;
        }
        int length = this.getUrl().length();
        if (length < min) {
            throw new IllegalArgumentException("URL must be longer than " + min + " characters");
        }
        if (length > max) {
            throw new IllegalArgumentException("URL must be less than " + max + " characters");
        }
    }
}

