/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.verify.CheckRequest;
import com.vonage.client.verify.CheckResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;

class CheckEndpoint
extends AbstractMethod<CheckRequest, CheckResponse> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/verify/check/json";

    CheckEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(CheckRequest request) throws UnsupportedEncodingException {
        if (request.getRequestId() == null || request.getCode() == null) {
            throw new IllegalArgumentException("request ID and code parameters are mandatory.");
        }
        RequestBuilder result = RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH)).setHeader("Content-Type", "application/json").setHeader("Accept", "application/json").addParameter("request_id", request.getRequestId()).addParameter("code", request.getCode());
        if (request.getIpAddress() != null) {
            result.addParameter("ip_address", request.getIpAddress());
        }
        return result;
    }

    @Override
    public CheckResponse parseResponse(HttpResponse response) throws IOException {
        return CheckResponse.fromJson(basicResponseHandler.handleResponse(response));
    }
}

