/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.verify.Psd2Request;
import com.vonage.client.verify.VerifyResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;

class Psd2Endpoint
extends AbstractMethod<Psd2Request, VerifyResponse> {
    private static final String PATH = "/verify/psd2/json";
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};

    public Psd2Endpoint(HttpWrapper wrapper) {
        super(wrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(Psd2Request request) throws UnsupportedEncodingException {
        RequestBuilder builder = RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH)).setHeader("Accept", "application/json").addParameter("number", request.getNumber()).addParameter("payee", request.getPayee()).addParameter("amount", Double.toString(request.getAmount()));
        if (request.getWorkflow() != null) {
            builder.addParameter("workflow_id", Integer.toString(request.getWorkflow().getId()));
        }
        this.optionalParams(builder, "code_length", request.getLength());
        this.optionalParams(builder, "lg", request.getDashedLocale());
        this.optionalParams(builder, "country", request.getCountry());
        this.optionalParams(builder, "pin_expiry", request.getPinExpiry());
        this.optionalParams(builder, "next_event_wait", request.getNextEventWait());
        return builder;
    }

    @Override
    public VerifyResponse parseResponse(HttpResponse response) throws IOException {
        return VerifyResponse.fromJson(basicResponseHandler.handleResponse(response));
    }

    private void optionalParams(RequestBuilder builder, String paramName, Object value) {
        if (value != null) {
            builder.addParameter(paramName, value + "");
        }
    }
}

