/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.verify.VerifyRequest;
import com.vonage.client.verify.VerifyResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.message.BasicNameValuePair;

class VerifyEndpoint
extends AbstractMethod<VerifyRequest, VerifyResponse> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/verify/json";

    VerifyEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(VerifyRequest request) throws UnsupportedEncodingException {
        RequestBuilder result = RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH)).setHeader("Content-Type", "application/json").setHeader("Accept", "application/json").addParameter("number", request.getNumber()).addParameter("brand", request.getBrand());
        if (request.getFrom() != null) {
            result.addParameter("sender_id", request.getFrom());
        }
        if (request.getLength() != null && request.getLength() > 0) {
            result.addParameter("code_length", Integer.toString(request.getLength()));
        }
        if (request.getLocale() != null) {
            result.addParameter((NameValuePair)new BasicNameValuePair("lg", request.getDashedLocale()));
        }
        if (request.getType() != null) {
            result.addParameter("require_type", request.getType().toString());
        }
        if (request.getCountry() != null) {
            result.addParameter("country", request.getCountry());
        }
        if (request.getPinExpiry() != null) {
            result.addParameter("pin_expiry", request.getPinExpiry().toString());
        }
        if (request.getNextEventWait() != null) {
            result.addParameter("next_event_wait", request.getNextEventWait().toString());
        }
        if (request.getWorkflow() != null) {
            result.addParameter("workflow_id", String.valueOf(request.getWorkflow().getId()));
        }
        return result;
    }

    @Override
    public VerifyResponse parseResponse(HttpResponse response) throws IOException {
        return VerifyResponse.fromJson(basicResponseHandler.handleResponse(response));
    }
}

