/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.verify.BaseRequest;
import java.util.Locale;

public class VerifyRequest
extends BaseRequest {
    private LineType type;
    private String brand;
    private String from;
    private Workflow workflow;

    public VerifyRequest(Builder builder) {
        super(builder.number, builder.length, builder.locale, builder.country, builder.pinExpiry, builder.nextEventWait);
        this.brand = builder.brand;
        this.from = builder.senderId;
        this.type = builder.type;
        this.workflow = builder.workflow;
    }

    public String getBrand() {
        return this.brand;
    }

    public LineType getType() {
        return this.type;
    }

    public String getFrom() {
        return this.from;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    @Override
    public String toString() {
        return "VerifyRequest{" + super.toString() + ", type=" + (Object)((Object)this.type) + ", brand='" + this.brand + '\'' + ", workflow=" + (Object)((Object)this.workflow) + '}';
    }

    public static Builder builder(String number, String brand) {
        return new Builder(number, brand);
    }

    public static class Builder {
        private String brand;
        private String senderId;
        private LineType type;
        private Workflow workflow;
        private String number;
        private Locale locale;
        private Integer length;
        private Integer pinExpiry;
        private Integer nextEventWait;
        private String country;

        public Builder(String number, String brand) {
            this.number = number;
            this.brand = brand;
        }

        public Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder type(LineType type) {
            this.type = type;
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public Builder pinExpiry(Integer pinExpiry) {
            this.pinExpiry = pinExpiry;
            return this;
        }

        public Builder nextEventWait(Integer nextEventWait) {
            this.nextEventWait = nextEventWait;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public VerifyRequest build() {
            return new VerifyRequest(this);
        }
    }

    public static enum LineType {
        ALL,
        MOBILE,
        LANDLINE;

    }

    public static enum Workflow {
        SMS_TTS_TTS(1),
        SMS_SMS_TTS(2),
        TTS_TTS(3),
        SMS_SMS(4),
        SMS_TTS(5),
        SMS(6),
        TTS(7);

        private final int id;

        private Workflow(int id) {
            this.id = id;
        }

        @JsonValue
        public int getId() {
            return this.id;
        }
    }
}

