/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.voice.Endpoint;
import com.vonage.client.voice.MachineDetection;
import com.vonage.client.voice.PhoneEndpoint;
import com.vonage.client.voice.ncco.Action;
import java.io.IOException;
import java.util.Collection;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"_links"})
public class Call {
    private Endpoint[] to;
    private Endpoint from;
    private String answerMethod = "GET";
    private String answerUrl;
    private String eventUrl;
    private String eventMethod;
    private MachineDetection machineDetection;
    private Integer lengthTimer;
    private Integer ringingTimer;
    private Boolean fromRandomNumber;
    private Collection<? extends Action> ncco;

    public Call() {
    }

    public Call(String to, String from, String answerUrl) {
        this((Endpoint)new PhoneEndpoint(to), (Endpoint)new PhoneEndpoint(from), answerUrl);
    }

    public Call(Endpoint to, Endpoint from, String answerUrl) {
        this(new Endpoint[]{to}, from, answerUrl);
    }

    public Call(String to, String from, Collection<? extends Action> ncco) {
        this((Endpoint)new PhoneEndpoint(to), (Endpoint)new PhoneEndpoint(from), ncco);
    }

    public Call(Endpoint to, Endpoint from, Collection<? extends Action> ncco) {
        this(new Endpoint[]{to}, from, ncco);
    }

    public Call(Endpoint[] to, Endpoint from, String answerUrl) {
        this.to = to;
        this.from = from;
        this.answerUrl = answerUrl;
    }

    public Call(Endpoint[] to, Endpoint from, Collection<? extends Action> ncco) {
        this.to = to;
        this.from = from;
        this.ncco = ncco;
    }

    public Endpoint[] getTo() {
        return this.to;
    }

    public void setTo(Endpoint[] to) {
        this.to = to;
    }

    public Endpoint getFrom() {
        return this.from;
    }

    public void setFrom(Endpoint from) {
        this.from = from;
    }

    @JsonProperty(value="answer_url")
    public String[] getAnswerUrl() {
        String[] stringArray;
        if (this.answerUrl != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.answerUrl;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public void setAnswerUrl(String answerUrl) {
        this.answerUrl = answerUrl;
    }

    @JsonProperty(value="answer_method")
    public String getAnswerMethod() {
        return this.answerUrl != null ? this.answerMethod : null;
    }

    public void setAnswerMethod(String answerMethod) {
        this.answerMethod = answerMethod;
    }

    @JsonProperty(value="event_url")
    public String[] getEventUrl() {
        if (this.eventUrl == null) {
            return null;
        }
        return new String[]{this.eventUrl};
    }

    public void setEventUrl(String eventUrl) {
        this.eventUrl = eventUrl;
    }

    @JsonProperty(value="event_method")
    public String getEventMethod() {
        return this.eventMethod;
    }

    public void setEventMethod(String eventMethod) {
        this.eventMethod = eventMethod;
    }

    @JsonProperty(value="machine_detection")
    public MachineDetection getMachineDetection() {
        return this.machineDetection;
    }

    public void setMachineDetection(MachineDetection machineDetection) {
        this.machineDetection = machineDetection;
    }

    @JsonProperty(value="length_timer")
    public Integer getLengthTimer() {
        return this.lengthTimer;
    }

    public void setLengthTimer(Integer lengthTimer) {
        this.lengthTimer = lengthTimer;
    }

    @JsonProperty(value="ringing_timer")
    public Integer getRingingTimer() {
        return this.ringingTimer;
    }

    public void setRingingTimer(Integer ringingTimer) {
        this.ringingTimer = ringingTimer;
    }

    @JsonProperty(value="from_random_number")
    public Boolean getFromRandomNumber() {
        return this.fromRandomNumber;
    }

    public void setFromRandomNumber(Boolean fromRandomNumber) {
        this.fromRandomNumber = fromRandomNumber;
    }

    @JsonProperty(value="ncco")
    public Collection<? extends Action> getNcco() {
        return this.ncco;
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            throw new VonageUnexpectedException("Failed to produce json from Call object.", jpe);
        }
    }

    public static Call fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (Call)mapper.readValue(json, Call.class);
        }
        catch (IOException jpe) {
            throw new VonageUnexpectedException("Failed to produce json from Call object.", jpe);
        }
    }
}

