/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.voice.CallInfoPage;
import com.vonage.client.voice.CallsFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;

class ListCallsEndpoint
extends AbstractMethod<CallsFilter, CallInfoPage> {
    private static final String PATH = "/calls";
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class};

    ListCallsEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(CallsFilter filter) throws UnsupportedEncodingException {
        URIBuilder uriBuilder;
        String uri = this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v1") + PATH;
        try {
            uriBuilder = new URIBuilder(uri);
        }
        catch (URISyntaxException e) {
            throw new VonageUnexpectedException("Could not parse URI: " + uri);
        }
        if (filter != null) {
            List<NameValuePair> params = filter.toUrlParams();
            for (NameValuePair param : params) {
                uriBuilder.setParameter(param.getName(), param.getValue());
            }
        }
        return RequestBuilder.get((String)uriBuilder.toString()).setHeader("Accept", "application/json");
    }

    @Override
    public CallInfoPage parseResponse(HttpResponse response) throws IOException {
        return CallInfoPage.fromJson(basicResponseHandler.handleResponse(response));
    }
}

