/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.voice.CallInfo;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;

class ReadCallEndpoint
extends AbstractMethod<String, CallInfo> {
    private static final String PATH = "/calls/";
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class};

    ReadCallEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(String callId) {
        String uri = this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v1") + PATH + callId;
        return RequestBuilder.get((String)uri).setHeader("Accept", "application/json");
    }

    @Override
    public CallInfo parseResponse(HttpResponse response) throws IOException {
        return CallInfo.fromJson(basicResponseHandler.handleResponse(response));
    }
}

