/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.voice.Call;
import com.vonage.client.voice.CallEvent;
import com.vonage.client.voice.CallInfo;
import com.vonage.client.voice.CallInfoPage;
import com.vonage.client.voice.CallModifier;
import com.vonage.client.voice.CallsFilter;
import com.vonage.client.voice.CreateCallEndpoint;
import com.vonage.client.voice.DownloadRecordingEndpoint;
import com.vonage.client.voice.DtmfEndpoint;
import com.vonage.client.voice.DtmfRequest;
import com.vonage.client.voice.DtmfResponse;
import com.vonage.client.voice.ListCallsEndpoint;
import com.vonage.client.voice.ModifyCallAction;
import com.vonage.client.voice.ModifyCallEndpoint;
import com.vonage.client.voice.ModifyCallResponse;
import com.vonage.client.voice.ReadCallEndpoint;
import com.vonage.client.voice.Recording;
import com.vonage.client.voice.StartStreamEndpoint;
import com.vonage.client.voice.StartTalkEndpoint;
import com.vonage.client.voice.StopStreamEndpoint;
import com.vonage.client.voice.StopTalkEndpoint;
import com.vonage.client.voice.StreamRequest;
import com.vonage.client.voice.StreamResponse;
import com.vonage.client.voice.TalkRequest;
import com.vonage.client.voice.TalkResponse;
import com.vonage.client.voice.TextToSpeechLanguage;
import com.vonage.client.voice.ncco.Ncco;

public class VoiceClient {
    final CreateCallEndpoint createCall;
    final ReadCallEndpoint readCall;
    final ListCallsEndpoint listCalls;
    final ModifyCallEndpoint modifyCall;
    final StartStreamEndpoint startStream;
    final StopStreamEndpoint stopStream;
    final StartTalkEndpoint startTalk;
    final StopTalkEndpoint stopTalk;
    final DtmfEndpoint dtmf;
    final DownloadRecordingEndpoint downloadRecording;

    public VoiceClient(HttpWrapper httpWrapper) {
        this.createCall = new CreateCallEndpoint(httpWrapper);
        this.readCall = new ReadCallEndpoint(httpWrapper);
        this.listCalls = new ListCallsEndpoint(httpWrapper);
        this.modifyCall = new ModifyCallEndpoint(httpWrapper);
        this.startStream = new StartStreamEndpoint(httpWrapper);
        this.stopStream = new StopStreamEndpoint(httpWrapper);
        this.startTalk = new StartTalkEndpoint(httpWrapper);
        this.stopTalk = new StopTalkEndpoint(httpWrapper);
        this.dtmf = new DtmfEndpoint(httpWrapper);
        this.downloadRecording = new DownloadRecordingEndpoint(httpWrapper);
    }

    public CallEvent createCall(Call callRequest) throws VonageResponseParseException, VonageClientException {
        return (CallEvent)this.createCall.execute(callRequest);
    }

    public CallInfoPage listCalls() throws VonageResponseParseException, VonageClientException {
        return this.listCalls(null);
    }

    public CallInfoPage listCalls(CallsFilter filter) throws VonageResponseParseException, VonageClientException {
        return (CallInfoPage)this.listCalls.execute(filter);
    }

    public CallInfo getCallDetails(String uuid) throws VonageResponseParseException, VonageClientException {
        return (CallInfo)this.readCall.execute(uuid);
    }

    public DtmfResponse sendDtmf(String uuid, String digits) throws VonageResponseParseException, VonageClientException {
        return (DtmfResponse)this.dtmf.execute(new DtmfRequest(uuid, digits));
    }

    public ModifyCallResponse modifyCall(String uuid, ModifyCallAction action) throws VonageResponseParseException, VonageClientException {
        return this.modifyCall(new CallModifier(uuid, action));
    }

    public ModifyCallResponse modifyCall(CallModifier modifier) throws VonageResponseParseException, VonageClientException {
        return (ModifyCallResponse)this.modifyCall.execute(modifier);
    }

    public ModifyCallResponse transferCall(String uuid, String nccoUrl) throws VonageResponseParseException, VonageClientException {
        return this.modifyCall(CallModifier.transferCall(uuid, nccoUrl));
    }

    public ModifyCallResponse transferCall(String uuid, Ncco ncco) throws VonageResponseParseException, VonageClientException {
        return this.modifyCall(CallModifier.transferCall(uuid, ncco));
    }

    public StreamResponse startStream(String uuid, String streamUrl, int loop) throws VonageResponseParseException, VonageClientException {
        return (StreamResponse)this.startStream.execute(new StreamRequest(uuid, streamUrl, loop));
    }

    public StreamResponse startStream(String uuid, String streamUrl) throws VonageResponseParseException, VonageClientException {
        return this.startStream(uuid, streamUrl, 1);
    }

    public StreamResponse stopStream(String uuid) throws VonageResponseParseException, VonageClientException {
        return (StreamResponse)this.stopStream.execute(uuid);
    }

    public TalkResponse startTalk(String uuid, String text) throws VonageResponseParseException, VonageClientException {
        return (TalkResponse)this.startTalk.execute(new TalkRequest(uuid, text));
    }

    public TalkResponse startTalk(String uuid, String text, TextToSpeechLanguage language) throws VonageResponseParseException, VonageClientException {
        return (TalkResponse)this.startTalk.execute(new TalkRequest(uuid, text, language));
    }

    public TalkResponse startTalk(String uuid, String text, int loop) throws VonageResponseParseException, VonageClientException {
        return (TalkResponse)this.startTalk.execute(new TalkRequest(uuid, text, loop));
    }

    public TalkResponse startTalk(String uuid, String text, TextToSpeechLanguage language, int style, int loop) throws VonageResponseParseException, VonageClientException {
        return (TalkResponse)this.startTalk.execute(new TalkRequest(uuid, text, language, style, loop));
    }

    public TalkResponse startTalk(String uuid, String text, TextToSpeechLanguage language, int style) throws VonageResponseParseException, VonageClientException {
        return (TalkResponse)this.startTalk.execute(new TalkRequest(uuid, text, language, style));
    }

    public TalkResponse stopTalk(String uuid) throws VonageResponseParseException, VonageClientException {
        return (TalkResponse)this.stopTalk.execute(uuid);
    }

    public Recording downloadRecording(String recordingUrl) throws VonageResponseParseException, VonageClientException {
        return (Recording)this.downloadRecording.execute(recordingUrl);
    }
}

