/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.vonage.client.voice.ncco.Endpoint;
import java.net.URI;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SipEndpoint
implements Endpoint {
    private static final String TYPE = "sip";
    private final URI uri;
    private final Map<String, ?> headers;

    private SipEndpoint(Builder builder) {
        this.uri = builder.uri;
        this.headers = builder.headers;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<String, ?> getHeaders() {
        return this.headers;
    }

    public static Builder builder(String uri) {
        return SipEndpoint.builder(URI.create(uri));
    }

    public static Builder builder(URI uri) {
        return new Builder(uri);
    }

    public static class Builder {
        private URI uri;
        private Map<String, ?> headers;

        Builder(URI uri) {
            this.uri = uri;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder uri(String uri) {
            return this.uri(URI.create(uri));
        }

        public Builder headers(Map<String, ?> headers) {
            this.headers = headers;
            return this;
        }

        public SipEndpoint build() {
            return new SipEndpoint(this);
        }
    }
}

