/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application;

import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageBadRequestException;
import com.vonage.client.VonageClientException;
import com.vonage.client.application.ApplicationMethod;
import com.vonage.client.auth.TokenAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;

class DeleteApplicationEndpoint
extends ApplicationMethod<String, Void> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/applications/%s";

    DeleteApplicationEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(String id) throws UnsupportedEncodingException {
        String uri = this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v2") + String.format(PATH, id);
        return RequestBuilder.delete((String)uri);
    }

    @Override
    public Void parseResponse(HttpResponse response) throws IOException, VonageClientException {
        if (response.getStatusLine().getStatusCode() != 204) {
            throw new VonageBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return null;
    }
}

