/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.insight.AdvancedInsightRequest;
import com.vonage.client.insight.AdvancedInsightResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;

class AdvancedInsightEndpoint
extends AbstractMethod<AdvancedInsightRequest, AdvancedInsightResponse> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/ni/advanced/json";
    private static final String ASYNC_PATH = "/ni/advanced/async/json";

    AdvancedInsightEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(AdvancedInsightRequest request) throws UnsupportedEncodingException {
        String uri = this.httpWrapper.getHttpConfig().getApiBaseUri() + (request.isAsync() ? ASYNC_PATH : PATH);
        RequestBuilder requestBuilder = RequestBuilder.post((String)uri).setHeader("Accept", "application/json").addParameter("number", request.getNumber());
        if (request.getCountry() != null) {
            requestBuilder.addParameter("country", request.getCountry());
        }
        if (request.getIpAddress() != null) {
            requestBuilder.addParameter("ip", request.getIpAddress());
        }
        if (request.getCnam() != null) {
            requestBuilder.addParameter("cnam", request.getCnam().toString());
        }
        if (request.getCallback() != null) {
            requestBuilder.addParameter("callback", request.getCallback());
        }
        if (request.getRealTimeData() != null) {
            requestBuilder.addParameter("real_time_data", request.getRealTimeData().toString());
        }
        return requestBuilder;
    }

    @Override
    public AdvancedInsightResponse parseResponse(HttpResponse response) throws IOException {
        return AdvancedInsightResponse.fromJson(basicResponseHandler.handleResponse(response));
    }
}

