/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.vonage.client.insight.RoamingDetails;
import java.io.IOException;

public class RoamingDeseriazlizer
extends StdDeserializer<RoamingDetails> {
    public RoamingDeseriazlizer() {
        this(null);
    }

    public RoamingDeseriazlizer(Class<?> vc) {
        super(vc);
    }

    public RoamingDetails deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        RoamingDetails.RoamingStatus status = RoamingDetails.RoamingStatus.UNKNOWN;
        String roamingCountryCode = null;
        String roamingNetworkCode = null;
        String roamingNetworkName = null;
        if (node.getNodeType() == JsonNodeType.STRING) {
            status = RoamingDetails.RoamingStatus.fromString(node.asText());
        } else if (node.getNodeType() == JsonNodeType.OBJECT) {
            status = RoamingDetails.RoamingStatus.fromString(node.get("status").asText());
            if (node.get("roaming_country_code") != null) {
                roamingCountryCode = node.get("roaming_country_code").asText();
            }
            if (node.get("roaming_network_code") != null) {
                roamingNetworkCode = node.get("roaming_network_code").asText();
            }
            if (node.get("roaming_network_name") != null) {
                roamingNetworkName = node.get("roaming_network_name").asText();
            }
        }
        return new RoamingDetails(status, roamingCountryCode, roamingNetworkCode, roamingNetworkName);
    }
}

