/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.messages.Channel;
import java.io.IOException;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Currency;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessageStatus {
    static final String ISO_8601_PATTERN = "yyyy-MM-dd HH:mm:ss Z";
    protected static final DateTimeFormatter ISO_8601 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z");
    @JsonProperty(value="timestamp")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss Z")
    protected ZonedDateTime timestamp;
    @JsonProperty(value="message_uuid")
    protected UUID messageUuid;
    @JsonProperty(value="to")
    protected String to;
    @JsonProperty(value="from")
    protected String from;
    @JsonProperty(value="status")
    protected Status status;
    @JsonProperty(value="channel")
    protected Channel channel;
    @JsonProperty(value="client_ref")
    protected String clientRef;
    @JsonProperty(value="error")
    protected Error error;
    @JsonProperty(value="usage")
    protected Usage usage;

    protected MessageStatus() {
    }

    public UUID getMessageUuid() {
        return this.messageUuid;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    protected void setTimestamp(String timestamp) {
        this.timestamp = ISO_8601.parse((CharSequence)timestamp, ZonedDateTime::from);
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    protected void setStatus(String status) {
        this.status = Status.fromString(status);
    }

    public Status getStatus() {
        return this.status;
    }

    protected void setChannel(String channel) {
        this.channel = Channel.fromString(channel);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String getClientRef() {
        return this.clientRef;
    }

    public Error getError() {
        return this.error;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public static MessageStatus fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (MessageStatus)mapper.readValue(json, MessageStatus.class);
        }
        catch (IOException ex) {
            throw new VonageUnexpectedException("Failed to produce MessageStatus from json.", ex);
        }
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            throw new VonageUnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName() + " object.", jpe);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.toJson();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageStatus that = (MessageStatus)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.messageUuid, that.messageUuid) && Objects.equals(this.to, that.to) && Objects.equals(this.from, that.from) && this.status == that.status && this.channel == that.channel && Objects.equals(this.clientRef, that.clientRef) && Objects.equals(this.error, that.error) && Objects.equals(this.usage, that.usage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.messageUuid, this.to, this.from, this.status, this.channel, this.clientRef, this.error, this.usage});
    }

    public static enum Status {
        SUBMITTED,
        DELIVERED,
        REJECTED,
        UNDELIVERABLE,
        READ;


        @JsonCreator
        public static Status fromString(String value) {
            if (value == null) {
                return null;
            }
            return Status.valueOf(value.toUpperCase());
        }

        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class Error {
        @JsonProperty(value="type")
        URI type;
        @JsonProperty(value="title")
        String title;
        @JsonProperty(value="detail")
        String detail;
        @JsonProperty(value="instance")
        String instance;

        void setType(String type) {
            this.type = URI.create(type);
        }

        public URI getType() {
            return this.type;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getInstance() {
            return this.instance;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            return Objects.equals(this.type, error.type) && Objects.equals(this.title, error.title) && Objects.equals(this.detail, error.detail) && Objects.equals(this.instance, error.instance);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.title, this.detail, this.instance);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " {type='" + this.type + '\'' + ", title='" + this.title + '\'' + ", detail='" + this.detail + '\'' + ", instance='" + this.instance + "'}";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class Usage {
        @JsonProperty(value="price")
        double price;
        @JsonProperty(value="currency")
        Currency currency;

        void setCurrency(String currency) {
            this.currency = Currency.getInstance(currency);
        }

        public Currency getCurrency() {
            return this.currency;
        }

        void setPrice(String price) {
            this.price = Double.parseDouble(price);
        }

        public double getPrice() {
            return this.price;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Usage usage = (Usage)o;
            return Double.compare(usage.price, this.price) == 0 && Objects.equals(this.currency, usage.currency);
        }

        public int hashCode() {
            return Objects.hash(this.price, this.currency);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " {price=" + this.price + ", currency=" + this.currency + '}';
        }
    }
}

