/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.messages.MessageRequest;
import com.vonage.client.messages.MessageResponse;
import com.vonage.client.messages.MessageResponseException;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

class SendMessageEndpoint
extends AbstractMethod<MessageRequest, MessageResponse> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/v1/messages";
    private static final String SANDBOX_ENDPOINT_URI = "https://messages-sandbox.nexmo.com/v1/messages";
    private boolean sandbox = false;

    SendMessageEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    public void setSandboxed(boolean sandbox) {
        this.sandbox = sandbox;
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(MessageRequest request) {
        String uri = this.sandbox ? SANDBOX_ENDPOINT_URI : this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH;
        return RequestBuilder.post((String)uri).setHeader("Content-Type", "application/json").setHeader("Accept", "application/json").setEntity((HttpEntity)new StringEntity(request.toJson(), ContentType.APPLICATION_JSON));
    }

    @Override
    public MessageResponse parseResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            String json = basicResponseHandler.handleResponse(response);
            return MessageResponse.fromJson(json);
        }
        String json = EntityUtils.toString((HttpEntity)response.getEntity());
        MessageResponseException mrx = MessageResponseException.fromJson(json);
        if (mrx.title == null) {
            mrx.title = response.getStatusLine().getReasonPhrase();
        }
        mrx.statusCode = statusCode;
        throw mrx;
    }
}

