/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.mms;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.internal.MessagePayload;
import com.vonage.client.messages.mms.MmsRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class MmsVideoRequest
extends MmsRequest {
    MmsVideoRequest(Builder builder) {
        super(builder, MessageType.VIDEO);
        this.payload = new MessagePayload(builder.url, builder.caption);
        this.payload.validateCaptionLength(2000);
    }

    @JsonProperty(value="video")
    public MessagePayload getVideo() {
        return this.payload;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends MmsRequest.Builder<MmsVideoRequest, Builder> {
        String caption;

        Builder() {
        }

        @Override
        public Builder url(String url) {
            return (Builder)super.url(url);
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @Override
        public MmsVideoRequest build() {
            return new MmsVideoRequest(this);
        }
    }
}

