/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.viber;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessageRequest;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.internal.E164;
import com.vonage.client.messages.viber.Category;
import com.vonage.client.messages.viber.ViberService;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class ViberRequest
extends MessageRequest {
    protected final ViberService viberService;

    protected ViberRequest(Builder<?, ?> builder, MessageType messageType) {
        super(builder, Channel.VIBER, messageType);
        this.viberService = ViberService.construct(builder.category, builder.ttl, builder.viberType);
    }

    @Override
    protected void validateSenderAndRecipient(String from, String to) throws IllegalArgumentException {
        if (from == null || from.isEmpty()) {
            throw new IllegalArgumentException("Sender ID cannot be empty");
        }
        if (from.length() > 50) {
            throw new IllegalArgumentException("Sender ID cannot be longer than 50 characters");
        }
        this.to = new E164(to).toString();
    }

    @JsonProperty(value="viber_service")
    public ViberService getViberService() {
        return this.viberService;
    }

    protected static abstract class Builder<M extends ViberRequest, B extends Builder<? extends M, ? extends B>>
    extends MessageRequest.Builder<M, B> {
        protected Category category;
        protected Integer ttl;
        protected String viberType;

        protected Builder() {
        }

        public B category(Category category) {
            this.category = category;
            return (B)this;
        }

        public B ttl(int ttl) {
            this.ttl = ttl;
            return (B)this;
        }

        public B viberType(String type) {
            this.viberType = type;
            return (B)this;
        }
    }
}

