/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.viber;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.viber.Category;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class ViberService {
    private final Category category;
    private final Integer ttl;
    private final String type;

    private ViberService(Category category, Integer ttl, String type) {
        this.category = category;
        this.ttl = ttl;
        this.type = type;
    }

    static ViberService construct(Category category, Integer ttl, String type) {
        if (category == null && ttl == null && type == null) {
            return null;
        }
        if (ttl != null && (ttl < 30 || ttl > 259200)) {
            throw new IllegalArgumentException("Time-to-live (ttl) must be between 30 and 259200 seconds");
        }
        return new ViberService(category, ttl, type);
    }

    @JsonProperty(value="category")
    public Category getCategory() {
        return this.category;
    }

    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }
}

