/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.internal.MessagePayload;
import com.vonage.client.messages.whatsapp.WhatsappRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class WhatsappImageRequest
extends WhatsappRequest {
    final MessagePayload image;

    WhatsappImageRequest(Builder builder) {
        super(builder, MessageType.IMAGE);
        this.image = new MessagePayload(builder.url, builder.caption);
        this.image.validateUrlExtension("jpg", "jpeg", "png");
        this.image.validateCaptionLength(3000);
    }

    @JsonProperty(value="image")
    public MessagePayload getImage() {
        return this.image;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WhatsappRequest.Builder<WhatsappImageRequest, Builder> {
        String url;
        String caption;

        Builder() {
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @Override
        public WhatsappImageRequest build() {
            return new WhatsappImageRequest(this);
        }
    }
}

