/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.sms;

import com.vonage.client.VonageUnexpectedException;
import java.io.UnsupportedEncodingException;

public class HexUtil {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private HexUtil() {
    }

    public static String bytesToHex(byte[] bytes) {
        return HexUtil.bytesToHex(bytes, null);
    }

    public static String bytesToHex(byte[] bytes, String separator) {
        StringBuilder tmpBuffer = new StringBuilder();
        if (bytes != null) {
            for (int n : bytes) {
                int b = n;
                if (b < 0) {
                    b += 256;
                }
                if (separator != null) {
                    tmpBuffer.append(separator);
                }
                tmpBuffer.append(HEX_CHARS[(b & 0xF0) / 16]);
                tmpBuffer.append(HEX_CHARS[b & 0xF]);
            }
        }
        return tmpBuffer.toString();
    }

    public static byte[] hexToBytes(String str) {
        byte[] hexChars;
        if (str == null) {
            return null;
        }
        try {
            hexChars = str.toUpperCase().getBytes("ISO_8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new VonageUnexpectedException("ISO_8859_1 is an unsupported encoding in this JVM");
        }
        int size = hexChars.length;
        byte[] bytes = new byte[size / 2];
        int rIndex = 0;
        int i = 0;
        while (i + 1 < size) {
            int first = hexChars[i];
            first = first < 58 ? (first - 48) * 16 : (first - 55) * 16;
            int second = hexChars[i + 1];
            second = second < 58 ? (second -= 48) : (second -= 55);
            int total = first + second;
            if (total > 127) {
                total = 256 + total;
            }
            bytes[rIndex] = (byte)total;
            ++rIndex;
            i += 2;
        }
        return bytes;
    }
}

