/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import java.util.Locale;

public abstract class BaseRequest {
    private final String number;
    private final String country;
    private final Integer length;
    private final Integer pinExpiry;
    private final Integer nextEventWait;
    private final Locale locale;

    protected BaseRequest(String number, Integer length, Locale locale, String country, Integer pinExpiry, Integer nextEventWait) {
        this.number = number;
        this.length = length;
        this.locale = locale;
        this.country = country;
        this.pinExpiry = pinExpiry;
        if (this.pinExpiry != null && (pinExpiry < 60 || pinExpiry > 3600)) {
            throw new IllegalArgumentException("pin_expiry '" + pinExpiry + "' is out of bounds");
        }
        this.nextEventWait = nextEventWait;
        if (this.nextEventWait != null && (nextEventWait < 60 || nextEventWait > 900)) {
            throw new IllegalArgumentException("next_event_wait '" + nextEventWait + "' is out of bounds");
        }
    }

    public String getNumber() {
        return this.number;
    }

    public Integer getLength() {
        return this.length;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getDashedLocale() {
        if (this.locale != null) {
            return this.locale.toLanguageTag().toLowerCase();
        }
        return null;
    }

    public String getCountry() {
        return this.country;
    }

    public Integer getPinExpiry() {
        return this.pinExpiry;
    }

    public Integer getNextEventWait() {
        return this.nextEventWait;
    }

    public String toString() {
        return "number='" + this.number + '\'' + ", length=" + this.length + ", locale=" + this.locale + ", country='" + this.country + '\'' + ", pinExpiry=" + this.pinExpiry + ", nextEventWait=" + this.nextEventWait;
    }
}

