/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.verify.VerifyStatus;
import java.io.IOException;
import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CheckResponse {
    private String requestId;
    private String eventId;
    private String currency;
    private String errorText;
    private final VerifyStatus status;
    private BigDecimal price;
    private BigDecimal estimatedPriceMessagesSent;

    @JsonCreator
    public CheckResponse(@JsonProperty(value="status", required=true) VerifyStatus status) {
        this.status = status;
    }

    @JsonProperty(value="request_id")
    public String getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="event_id")
    public String getEventId() {
        return this.eventId;
    }

    public VerifyStatus getStatus() {
        return this.status;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="error_text")
    public String getErrorText() {
        return this.errorText;
    }

    @JsonProperty(value="estimated_price_messages_sent")
    public BigDecimal getEstimatedPriceMessagesSent() {
        return this.estimatedPriceMessagesSent;
    }

    public static CheckResponse fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (CheckResponse)mapper.readValue(json, CheckResponse.class);
        }
        catch (JsonMappingException jme) {
            throw new VonageResponseParseException("Failed to produce CheckResponse from json.", jme);
        }
        catch (IOException jpe) {
            throw new VonageUnexpectedException("Failed to produce CheckResponse from json.", jpe);
        }
    }
}

