/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.verify.SearchRequest;
import com.vonage.client.verify.SearchVerifyResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;

class SearchEndpoint
extends AbstractMethod<SearchRequest, SearchVerifyResponse> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/verify/search/json";

    SearchEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(SearchRequest request) throws UnsupportedEncodingException {
        String uri = this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH;
        RequestBuilder result = RequestBuilder.post((String)uri).setHeader("Accept", "application/json");
        if (request.getRequestIds().length == 1) {
            result.addParameter("request_id", request.getRequestIds()[0]);
        } else {
            for (String requestId : request.getRequestIds()) {
                result.addParameter("request_ids", requestId);
            }
        }
        return result;
    }

    @Override
    public SearchVerifyResponse parseResponse(HttpResponse response) throws IOException {
        return SearchVerifyResponse.fromJson(basicResponseHandler.handleResponse(response));
    }
}

