/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.verify.BaseRequest;
import java.util.Locale;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.message.BasicNameValuePair;

public class VerifyRequest
extends BaseRequest {
    private final LineType type;
    private final String brand;
    private final String from;
    private final Workflow workflow;

    public VerifyRequest(Builder builder) {
        super(builder.number, builder.length, builder.locale, builder.country, builder.pinExpiry, builder.nextEventWait);
        this.brand = builder.brand;
        if (this.brand != null && this.brand.length() > 18) {
            throw new IllegalArgumentException("Brand '" + this.brand + "' is longer than 18 characters");
        }
        this.from = builder.senderId;
        this.type = builder.type;
        this.workflow = builder.workflow;
    }

    public String getBrand() {
        return this.brand;
    }

    @Deprecated
    public LineType getType() {
        return this.type;
    }

    public String getFrom() {
        return this.from;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    protected void addParams(RequestBuilder result) {
        result.addParameter("number", this.getNumber()).addParameter("brand", this.getBrand());
        if (this.getFrom() != null) {
            result.addParameter("sender_id", this.getFrom());
        }
        if (this.getLength() != null && this.getLength() > 0) {
            result.addParameter("code_length", Integer.toString(this.getLength()));
        }
        if (this.getLocale() != null) {
            result.addParameter((NameValuePair)new BasicNameValuePair("lg", this.getDashedLocale()));
        }
        if (this.getCountry() != null) {
            result.addParameter("country", this.getCountry());
        }
        if (this.getPinExpiry() != null) {
            result.addParameter("pin_expiry", this.getPinExpiry().toString());
        }
        if (this.getNextEventWait() != null) {
            result.addParameter("next_event_wait", this.getNextEventWait().toString());
        }
        if (this.getWorkflow() != null) {
            result.addParameter("workflow_id", String.valueOf(this.getWorkflow().getId()));
        }
    }

    @Override
    public String toString() {
        return "VerifyRequest{" + super.toString() + ", type=" + (Object)((Object)this.type) + ", brand='" + this.brand + '\'' + ", workflow=" + (Object)((Object)this.workflow) + '}';
    }

    public static Builder builder(String number, String brand) {
        return new Builder(number, brand);
    }

    public static class Builder {
        private String brand;
        private String senderId;
        private String number;
        private String country;
        private Integer length;
        private Integer pinExpiry;
        private Integer nextEventWait;
        private LineType type;
        private Workflow workflow;
        private Locale locale;

        public Builder(String number, String brand) {
            this.number = number;
            this.brand = brand;
        }

        public Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        @Deprecated
        public Builder type(LineType type) {
            this.type = type;
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public Builder pinExpiry(Integer pinExpiry) {
            this.pinExpiry = pinExpiry;
            return this;
        }

        public Builder nextEventWait(Integer nextEventWait) {
            this.nextEventWait = nextEventWait;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public VerifyRequest build() {
            return new VerifyRequest(this);
        }
    }

    public static enum LineType {
        ALL,
        MOBILE,
        LANDLINE;

    }

    public static enum Workflow {
        SMS_TTS_TTS(1),
        SMS_SMS_TTS(2),
        TTS_TTS(3),
        SMS_SMS(4),
        SMS_TTS(5),
        SMS(6),
        TTS(7);

        private final int id;

        private Workflow(int id) {
            this.id = id;
        }

        @JsonValue
        public int getId() {
            return this.id;
        }
    }
}

