/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.voice.StreamRequest;
import com.vonage.client.voice.StreamResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

class StartStreamEndpoint
extends AbstractMethod<StreamRequest, StreamResponse> {
    private static final String PATH = "/calls/";
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class};

    StartStreamEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(StreamRequest request) throws UnsupportedEncodingException {
        String uri = this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v1") + PATH + request.getUuid() + "/stream";
        return RequestBuilder.put((String)uri).setHeader("Content-Type", "application/json").setHeader("Accept", "application/json").setEntity((HttpEntity)new StringEntity(request.toJson(), ContentType.APPLICATION_JSON));
    }

    @Override
    public StreamResponse parseResponse(HttpResponse response) throws IOException {
        return StreamResponse.fromJson(basicResponseHandler.handleResponse(response));
    }
}

