/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.vonage.client.HttpWrapper;
import com.vonage.client.Method;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageMethodFailedException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.AuthMethod;
import com.vonage.client.logging.LoggingUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.util.EntityUtils;

public abstract class AbstractMethod<RequestT, ResultT>
implements Method<RequestT, ResultT> {
    private static final Log LOG = LogFactory.getLog(AbstractMethod.class);
    protected static final BasicResponseHandler basicResponseHandler = new BasicResponseHandler();
    protected final HttpWrapper httpWrapper;
    private Set<Class<?>> acceptable;

    public AbstractMethod(HttpWrapper httpWrapper) {
        this.httpWrapper = httpWrapper;
    }

    @Override
    public ResultT execute(RequestT request) throws VonageResponseParseException, VonageClientException {
        try {
            HttpUriRequest httpRequest = this.applyAuth(this.makeRequest(request)).setHeader("User-Agent", this.httpWrapper.getUserAgent()).setCharset(StandardCharsets.UTF_8).build();
            LOG.debug((Object)("Request: " + httpRequest));
            if (LOG.isDebugEnabled() && httpRequest instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase enclosingRequest = (HttpEntityEnclosingRequestBase)httpRequest;
                LOG.debug((Object)EntityUtils.toString((HttpEntity)enclosingRequest.getEntity()));
            }
            HttpResponse response = this.httpWrapper.getHttpClient().execute(httpRequest);
            LOG.debug((Object)("Response: " + LoggingUtils.logResponse(response)));
            try {
                return this.parseResponse(response);
            }
            catch (IOException io) {
                throw new VonageResponseParseException("Unable to parse response.", io);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new VonageUnexpectedException("UTF-8 encoding is not supported by this JVM.", uee);
        }
        catch (IOException io) {
            throw new VonageMethodFailedException("Something went wrong while executing the HTTP request: " + io.getMessage() + ".", io);
        }
    }

    protected RequestBuilder applyAuth(RequestBuilder request) throws VonageClientException {
        return this.getAuthMethod(this.getAcceptableAuthMethods()).apply(request);
    }

    protected AuthMethod getAuthMethod(Class<?>[] acceptableAuthMethods) throws VonageClientException {
        if (this.acceptable == null) {
            this.acceptable = new HashSet();
            Collections.addAll(this.acceptable, acceptableAuthMethods);
        }
        return this.httpWrapper.getAuthCollection().getAcceptableAuthMethod(this.acceptable);
    }

    public void setHttpClient(HttpClient client) {
        this.httpWrapper.setHttpClient(client);
    }

    protected abstract Class<?>[] getAcceptableAuthMethods();

    public abstract RequestBuilder makeRequest(RequestT var1) throws UnsupportedEncodingException;

    public abstract ResultT parseResponse(HttpResponse var1) throws IOException;
}

