/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.vonage.client.HttpConfig;
import com.vonage.client.auth.AuthCollection;
import com.vonage.client.auth.AuthMethod;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpWrapper {
    private static final String CLIENT_NAME = "vonage-java-sdk";
    private static final String CLIENT_VERSION = "7.2.0";
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private static final String USER_AGENT = String.format("%s/%s java/%s", "vonage-java-sdk", "7.2.0", JAVA_VERSION);
    private AuthCollection authCollection;
    private HttpClient httpClient;
    private HttpConfig httpConfig;

    public HttpWrapper(AuthCollection authCollection) {
        this(HttpConfig.builder().build(), authCollection);
    }

    public HttpWrapper(HttpConfig httpConfig, AuthCollection authCollection) {
        this.authCollection = authCollection;
        this.httpConfig = httpConfig;
    }

    public HttpWrapper(AuthMethod ... authMethods) {
        this(HttpConfig.builder().build(), authMethods);
    }

    public HttpWrapper(HttpConfig httpConfig, AuthMethod ... authMethods) {
        this(new AuthCollection(authMethods));
        this.httpConfig = httpConfig;
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public AuthCollection getAuthCollection() {
        return this.authCollection;
    }

    public void setAuthCollection(AuthCollection authCollection) {
        this.authCollection = authCollection;
    }

    protected HttpClient createHttpClient() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(200);
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(StandardCharsets.UTF_8).build());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).build());
        RequestConfig requestConfig = RequestConfig.custom().build();
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setUserAgent(USER_AGENT).setDefaultRequestConfig(requestConfig).useSystemProperties().build();
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public String getUserAgent() {
        return USER_AGENT;
    }
}

