/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.account;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.account.PrefixPricingRequest;
import com.vonage.client.account.PrefixPricingResponse;
import com.vonage.client.auth.TokenAuthMethod;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;

class PrefixPricingEndpoint
extends AbstractMethod<PrefixPricingRequest, PrefixPricingResponse> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/account/get-prefix-pricing/outbound/%s";

    PrefixPricingEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(PrefixPricingRequest request) {
        String uri = this.httpWrapper.getHttpConfig().getRestBaseUri() + String.format(PATH, new Object[]{request.getServiceType()});
        return RequestBuilder.get((String)uri).setHeader("Accept", "application/json").addParameter("prefix", request.getPrefix());
    }

    @Override
    public PrefixPricingResponse parseResponse(HttpResponse response) throws IOException {
        return PrefixPricingResponse.fromJson(basicResponseHandler.handleResponse(response));
    }
}

