/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth.hashutils;

import com.vonage.client.auth.hashutils.AbstractHasher;
import com.vonage.client.auth.hashutils.HmacMd5Hasher;
import com.vonage.client.auth.hashutils.HmacSha1Hasher;
import com.vonage.client.auth.hashutils.HmacSha256Hasher;
import com.vonage.client.auth.hashutils.HmacSha512Hasher;
import com.vonage.client.auth.hashutils.Md5Hasher;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class HashUtil {
    private static Map<HashType, AbstractHasher> hashTypes = new HashMap<HashType, AbstractHasher>(){
        {
            this.put(HashType.MD5, new Md5Hasher());
            this.put(HashType.HMAC_SHA1, new HmacSha1Hasher());
            this.put(HashType.HMAC_MD5, new HmacMd5Hasher());
            this.put(HashType.HMAC_SHA256, new HmacSha256Hasher());
            this.put(HashType.HMAC_SHA512, new HmacSha512Hasher());
        }
    };

    public static String calculate(String input, HashType hashType) throws NoSuchAlgorithmException, InvalidKeyException {
        return hashTypes.get((Object)hashType).calculate(input);
    }

    public static String calculate(String input, String encoding, HashType hashType) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        return hashTypes.get((Object)hashType).calculate(input, encoding);
    }

    public static String calculate(String input, String secretKey, String encoding, HashType hashType) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        return hashTypes.get((Object)hashType).calculate(input, secretKey, encoding);
    }

    public static enum HashType {
        MD5,
        HMAC_SHA1,
        HMAC_MD5,
        HMAC_SHA256,
        HMAC_SHA512;

    }
}

